
do "COUNTRY 1. Prepare Data.do"

* ==============================================================================
* Calculate Lagged Variables (lag = before survey) =============================
* TWM = October 2011 - November 2012
* RILA = October 2013 - February 2014
* ==============================================================================

gen dvSHI = .
replace dvSHI = SHI2013 if muslim==1
replace dvSHI = SHI2015 if muslim==0

gen dvGRI = .
replace dvGRI = GRI2013 if muslim==1
replace dvGRI = GRI2015 if muslim==0

gen lagSHI = .
replace lagSHI = SHI2010 if muslim==1
replace lagSHI = SHI2012 if muslim==0

gen lagGRI = .
replace lagGRI = GRI2010 if muslim==1
replace lagGRI = GRI2012 if muslim==0

egen zdvSHIJOINED = std(dvSHI)
egen zdvGRIJOINED = std(dvGRI)
egen zlagSHIJOINED = std(lagSHI)
egen zlagGRIJOINED = std(lagGRI)

*===============================================================================
* SHI
*===============================================================================

log using "Table 2 and S8. Regression of Social Hostilities.log", replace

reg zdvSHIJOINED zbonding1JOINED zloggdppcJOINED zrdiJOINED zlagGRIJOINED zpolity2JOINED 
gen used_mod1 = e(sample)
estimates store m_shi1
estat esize
reg zdvSHIJOINED zbonding1JOINED zloggdppcJOINED zrdiJOINED zlagSHIJOINED zlagGRIJOINED zpolity2JOINED 
estimates store m_shi2
estat esize

esttab m* using "Table 2. Regression of Social Hostilities.csv", b(3) se(2) starlevels(+ .10 * .05 ** .01 *** .001) r2(3) nogaps replace
estimates clear

log close

